pico-8 cartridge // http://www.pico-8.com
version 18
__lua__

-- time in frames
t = 0
-- time in seconds
ts = 0

--part = 1
-- pattern time in seconds
pattern_time = 60 / 112.5 * 8
parttime={flr(2 * pattern_time),
flr(4 * pattern_time),
flr(8 * pattern_time),
flr(12 * pattern_time),
flr(18 * pattern_time),
flr(22 * pattern_time),
flr(26 * pattern_time),
flr(31 * pattern_time),
flr(35 * pattern_time),
flr(39 * pattern_time),
}

sint={}
stn=360
tso=0
function _init()
    print("loading",55,60,7)
    for i=1,stn do
        b = sin((i-1)/stn)
        add(sint,b)
    end
    tree_init()
    fshore_init()
    lbt_init()
    fp_init()
    llbk_init()
    bt_init()      
 	  arrows_init()
    tetra_init()
    starv_init()
    mt_init()
    cs_init()
    tso=time()
    music()
end

mirrored=false
function _update60()
    t+=1
    ts = time()-tso
    --[[ backgrounds
    llbk_update()
    arrows_update()

    -- foregrounds
	   tetra_update()
	   tetra2_update()
    stw_update()
    bt_update()
    fp_update()
    mt_update()
    lbt_update()
    --]]

    --[[ tester
    --stw_update()
    lbt_update()
    --fp_update()
    --]]

    -- main loop
    if ts < parttime[1] then
    elseif ts < parttime[2] then
    elseif ts < parttime[3] then
      pt = ts - parttime[2] 
      --llbk_update()
      bt_update(pt*60)
    elseif ts < parttime[4] then
      pt = ts - parttime[3] 
      --llbk_update()
      arrows_update()
      fp_update(pt*60)
    elseif ts < parttime[5] then
      cs_update()
--      arrows_update()
--      stw_update()
    elseif ts < parttime[6] then
      mt_update()
    elseif ts < parttime[7] then
      pt = ts - parttime[6] 
      lbt_update(pt*60)
    elseif ts < parttime[8] then
      tree_update()
    elseif ts < parttime[9] then
      llbk_update()
      arrows_update()
      tetra2_update()
    elseif ts < parttime[10] then
      if mirrored == false then 
        arcs_init()
        mirrored = true
      end
      llbk_update()
      tetra_update()
    else
      -- end loop
    end
    --]]

end

function _draw()
  local pt
    cls()

    --[[ foregrounds
    tetra()
    arcs() -- only works if 4-way mirrored
    bt()
    animtext('melrose', 60, 0, 0.4, 0)
    animtext('place', 60, 80, 0.3, 0)
    stw(t)
    pico3d_draw()
    lr()
    fp_draw()
    lbt_draw()
    mt_draw()

    ----- backgrounds
    chunky_draw()
    astetic()
    llbk()
    arrows()
    nu_draw(et)

    ----- colour effects
    fade_screen(1-(t/100))
    if (ts%2)>1 then invertpal() end
    pal() to undo
    --]]

    --[[ tester
    drawstringv("gas",60,0,.23,14,8)
    drawstringv("man",60,40,.23,14,7)
    drawstring("tratronic",104,69,.23,1,8)
    drawstring("boss",41,40,.23,1,8)
  --]]

    
    -- main code loop
    if ts < parttime[1] then
      if ts < pattern_time then
       fade_screen(ts/pattern_time)
      end
      lr(ts*20)
      palt(0)
      spr(166,48,0+clamp(t/20,0,16),4,2)
      spr(192,2,104-clamp(t/20,0,16),16,3)
      pal()
      --animtext('mantratronic', 60, 40, 0.4, 2)
      --animtext('gasman', 60, 40, 0.4, 6)
    elseif ts < parttime[2] then
      pt = ts - parttime[1] 
--[[      if ts > (parttime[2].t - pattern_time/2) then
        fade_screen((parttime[2].t-ts)/pattern_time)
      end
--]]      lr((pt*60) + (parttime[1]*20))
      
      if ts > (parttime[2] - pattern_time*1.5) then
        --for i = 1,3 do
          rectfill(0,10,128,25,0)
          drawstring("new",64,2,.65,1,7)
        --end
      end
      if ts > (parttime[2] - pattern_time) then
        --for i = 1,3 do
        rectfill(0,60,128,80,0)
        drawstring("school",64,50,.55,1,7)
      end
      if ts > (parttime[2] - pattern_time/2) then
      --for i = 1,3 do
       rectfill(0,100,128,118,0)
       drawstring("reunion",64,90,.50,1,7)
      end
      pal()
     elseif ts < parttime[3] then
      pt = ts - parttime[2] 
      nunu_draw(pt*60)
      local mxx = 300 - pt*20
      drawstringv("gas",mxx,20,.23,14,8)
      drawstringv("man",mxx,60,.23,14,7)
      drawstring("tratronic",44+mxx,89,.23,1,8)
      drawstring("boss",mxx-19,60,.23,1,8)
        bt(pt*60)
    elseif ts < parttime[4] then
      pt = ts - parttime[3] 
      nunu_draw(pt*60)
      pt2 = ts - parttime[2] 
      local mxx = 300 - pt2*20
      drawstring("tratronic",44+mxx,89,.23,1,8)
      arrows(pt*60)
      fp_draw(pt*60)
    elseif ts < parttime[5] then
      pt = ts - parttime[3]
      palt(0,false)
      palt(14,true)
      cs_draw() 
--[[      fillp()
      nunu_draw()
      arrows(pt*60)
      drawstring("mantratronic",64,20,.25,1.1,0)
      drawstring("gasman",64,60,.25,1.1,0)
      drawstring("bossman",64,100,.25,1.1,0)
      stw(pt*60)
      --]]
    elseif ts < parttime[6] then
      palt()
      astetic()
      mt_draw()
    elseif ts < parttime[7] then
      pt = ts - parttime[6]
      if pt>pattern_time then lbtt = lbtt2 end 
      if pt>(2*pattern_time) then lbtt = lbtt3 end 
      if pt>(3*pattern_time) then lbtt = lbtt4 end 
      nu_draw(t)
      lbt_draw(pt*60)
    elseif ts < parttime[8] then
      pt = ts - parttime[7]
      tree_draw() 
    elseif ts < parttime[9] then
      pt = ts - parttime[8] 
      llbk(pt*60)
      arrows(pt*60)
      tetra(pt*60)
    elseif ts < parttime[10] then
      invertpal()
      pt = ts - parttime[9] 
      llbk(pt*60)
      tetra(pt*60)
    else
      pal()
      pt = ts - parttime[10] 
      arcs(pt)
      palt(0)
      spr(68,30,40,4,2)
    end
    --]]

		--fps()
    --print("fps:"..((1/stat(1))*60),0,0,white)
--    print(stat(1),0,0,white)
end
---------------- bouncing lines
llbk_data={{2,10,-2},{10,89,1}}
function llbk_init()
 local d,p
 for i=1,10 do
  d = rnd(1)
  if d == 0 then
   d = -1
  end
  p = {1+rnd(2),rnd(128),d}
  add(llbk_data,p)
 end
end

function llbk(et)
 et = et or t
 cls(7)
 fillp(0x936c)
 for i = 1,#llbk_data do
  rectfill(0,llbk_data[i][2],128,llbk_data[i][2]+llbk_data[i][1]-1,247)
 end 
 fillp()
end

function llbk_update()
 for i = 1,#llbk_data do
  llbk_data[i][2]+=llbk_data[i][3]
  if llbk_data[i][2] < 0 then
   llbk_data[i][2] = 0
   llbk_data[i][3] *= -1
  elseif (llbk_data[i][2]+llbk_data[i][1]) > 128 then
   llbk_data[i][2] = 128 - llbk_data[i][1]
   llbk_data[i][3] *= -1
  end
 end
end

------------- nunu bg
function nunu_draw(et)
    et = et or t
    cls(2)
    for i=0,128 do
      local s = sin(i/196 + t/300 + .25)
      line(i,s*16,i,15+(16*(i/128)*(i/128)) + s*16,7)
      line(i,16 +(16*(i/128)*(i/128))+ s*16,i,32+(32*(i/128)*(i/128)) + s*16,10)
      line(i,32 +(32*(i/128)*(i/128))+ s*16,i,48+(48*(i/128)*(i/128)) + s*16,9)
  end
end
function nunu_update(et)
  et = et or t
end

------------- multi twister
mt_data={}
mt_levels = 10
mt_speed = -0.005
mt_offset={80,-20}
mt_width = 40
mt_lheight = 16
mt_dd={}
mt_fills={}
function mt_init()
  local level
  -- make array of levels, 4 points?, offset
  for i=1,mt_levels do
    level = {0,.25,.5,.75}
    add(mt_data,level)
    level = {-0.125,.125,.375,.625}
    add(mt_data,level)
  end
end

function mt_draw(et)
  local tri,nd,f
  local findex = 1
  et = et or t
  for i=1,#mt_dd do
    tri = mt_dd[i]
    -- check if to be filled
    if i == mt_fills[findex] then
      nd = (tri[1][1]+tri[2][1]+tri[3][1])/3
      f = fls[1+(flr(0.08*abs(mt_offset[1]-nd))%#fls) ]
      drawtri(tri[1][1],tri[1][2],tri[2][1],tri[2][2]+0.01,tri[3][1]+0.1,tri[3][2]+0.10,f,46)
      findex+=1
      fillp()
    else
      line(tri[1][1],tri[1][2],tri[2][1],tri[2][2],2)
      line(tri[2][1],tri[2][2],tri[3][1],tri[3][2],2)
      line(tri[3][1],tri[3][2],tri[1][1],tri[1][2],2)
    end
  end
end

function mt_gp(r,l)
  local xy = {0,0}
  local w = mt_width + 20 * fsin(l/10+t/100) + 10 *fsin(r+t/150)
  xy[1] = mt_offset[1] + w*fsin(r + 0.1*l)
  xy[2] = mt_offset[2] + mt_lheight*l
  return xy--rot2d(xy[1],xy[2],t/500)
end

function mt_rot(num)
  local rn = num
  if num > 4 then rn = num % 4 end
  if rn == 0 then rn = 4 end
  return rn
end


function mt_update(et)
  local level,nlevel,nnlevel,plevel,pl,nl,nnl,tri
  local ox = mt_offset[1]
  local oy = mt_offset[2]
  et = et or t
  -- rotate levels
  for i=1, #mt_data do
    level = mt_data[i]
    for j=1,4 do
      level[j]+=mt_speed
    end
  end
  -- move centre point
  mt_offset[1] = 80 + 10*fsin(t/800)
  -- update fill id's
  mt_fills = {}
  local mtst = 30 + 30 *fsin(t/200)
  for i=1,14 do
    add(mt_fills,flr(mtst + i))
  end
  add(mt_fills,-1)
  -- make draw coords
  mt_dd={}
  pl=0
  nnl=1
  for i=1,mt_levels do
    if i != 1 then 
      plevel = mt_data[(i-1)*2] 
      pl = (i-1)*2+1
    end
    nlevel = mt_data[i*2]
    if i != mt_levels then nnlevel = mt_data[(i+1)*2-1] else nnl = 0 end
    level = mt_data[i*2-1]
    for j=1,4 do
      -- back one, forward one, over up one and down one
      -- back one
      if nnl > 0  then 
        tri = {mt_gp(level[j],i),mt_gp(nnlevel[j],i+1),mt_gp(nlevel[j],i+.5)}
        if (tri[1][1]>=tri[3][1]) then add(mt_dd,tri) end
        -- forward one
        tri = {mt_gp(level[j],i),mt_gp(nlevel[mt_rot(j+1)],i+.5),mt_gp(nnlevel[j],i+1)}  
        if (tri[1][1]<=tri[2][1]) then add(mt_dd,tri) end
      end
    -- over up one
      if pl > 0 then 
--        tri = {mt_gp(level[j],i),mt_gp(plevel[(j+1)%4+1],i),mt_gp(level[(j+1)%4+1],i)}
        tri = {mt_gp(level[j],i),mt_gp(plevel[mt_rot(j+1)],i-.5),mt_gp(level[mt_rot(j+1)],i)}
        --tri = {mt_gp(.25,i),mt_gp(.5,i-.5),mt_gp(.3,i)}
        if (tri[1][1]<=tri[3][1]) then add(mt_dd,tri) end
      end
      -- over down one
      tri = {mt_gp(level[j],i),mt_gp(level[mt_rot(j+1)],i),mt_gp(nlevel[mt_rot(j+1)],i+.5)}  
      if (tri[1][1]<=tri[2][1]) then add(mt_dd,tri) end

    end
  end
end

-- fade in colour replace palette
fade_pal = {{0},{0,1},{0,2},{0,1,5,3},{0,2,4},{0,1,5},{0,1,5,13,6},{0,1,5,13,6,7},{0,2,8},{0,4,9},{0,4,9,10},{0,5,3,13,11},{0,1,13,12},{0,1,5,13},{0,2,8,14},{0,2,6,15}}
function fade_screen(et)
 local fpc
 for i=1,16 do
  fpc = fade_pal[i]
  pal(i-1,fpc[flr(et*#fpc)+1])
 end
end
-- scene poetry! greets? credits?

------------- nu background
function nu_draw(et)
    et = et or t
    cls(12)
    local x,wx,wy,sx,sy,oy,ox,mx,my,f
    wx = 16
    wy = 16
    ox = -16 + 8*sin(et/500) + et/100
    oy = -24 + 16*sin((et/500)+.25)
    f = 0xf000.1
    for i=1,12 do
      sx = ox + wx*((i-1)/2)
      mx=128+2*ox
      sy = oy + wy*((i-1))
      if i%2==1 then
        for j=0,wy-1 do
          x = sx+wx*smootherstep(0,wx,j)
          --fillp(bnot(f))
          line(x-wx,sy+j,x-wx/2,sy+j,192)
          line(mx-x+wx,sy+j,mx-x+wx/2,sy+j,192)
          --fillp(f)
          line(x,sy+j,x+wx,sy+j,194)
          line(mx-x,sy+j,mx-x-wx,sy+j,194)
        end
      else
        sx+=wx/2
        for j=0,wy-1 do
          --fillp(bnot(f))
          line(sx-wx,sy+j,sx-wx/2,sy+j,192)
          line(mx-sx+wx,sy+j,mx-sx+wx/2,sy+j,192)
          --fillp(f)
          line(sx,sy+j,sx+wx,sy+j,194)
          line(mx-sx,sy+j,mx-sx-wx,sy+j,194)
         end
       end
    end
    fillp()
end

------------- line ball w/ text
lbt_data={}
-- xyxy
lbtl={}
-- char, text
lbtt="code"
lbtt2="pixel"
lbtt3="track"
lbtt4="wedemo"
lbt_num = 100 -- 10^2
function lbt_init()
  local tmp = {0,0,1,0}
  local tc = {}
  local t1,t2
  for i = 1,10 do
    t1 =rotate3d(tmp,cent,i/10,0,0)
    add(tc,t1)
  end
  for i = 1,10 do
    t2 = {}
    for j = 1,10 do
      -- rotate the tc[j] point
      local tet = rotate3d(tc[i],{i/100,.1,0},0,0,j/10)
      -- add to t2
      add(lbt_data,tet)
    end
  end
end

function lbt_draw(et)
    et = et or t
    for i = 1, #lbtl do
      if flr(i+et/32)%13==0 then
        drawchar(sub(lbtt, i%#lbtt+1, i%#lbtt+1),lbtl[i][1],lbtl[i][2],0.2+0.08*fsin(i/10+et/250),15)
      else
       line(lbtl[i][1],lbtl[i][2],lbtl[i][3],lbtl[i][4],7)
      end
    end
end

function lbt_update(et)
  et = et or t
  local pr,ps1,ps2,pt1,pt2,a,b
  lbtl={}
  local sc = shore(et/300)
  sc = sc*sc * 5 + 24
  -- rotate, scale, place + scale, place
  for i = 1, #lbt_data do
   pr = rotate3d(lbt_data[i],cent,0,et/500,0)
   ps1= scale3d(pr,sc,sc,sc)
   pt1= translate3d(ps1,0,0,-30)
   ps2= scale3d(pr,sc+1,sc+1,sc+1)
   pt2= translate3d(ps2,0,0,-30)
--   if(pt1[3]<pt2[3]) then
    a = p3t2(pt1)
    b = p3t2(pt2)
    add(lbtl,{a[1],a[2],b[1],b[2]})
--    end
  end
end

------------- flowing pyramids
--centre point xyz, 3 rotations, size
fp_data={}
--4 points, lines to all others
fpls={}
fp_num=50

fpcols={1,5,13,12,6,7}
function fp_init()
 local fp
 for i=1,fp_num do
  fp = {rnd(900)/10 - 120,rnd(500)/10 - 40,0-50-rnd(500)/10,rnd(1000)/1000 +.5,rnd(1000)/1000 +.5,rnd(1000)/1000 +.5,rnd(100)/10}
  add(fp_data,fp)  
 end
 --zsort by centre point
 for i=1,#fp_data do
  local j = i
  while j > 1 and (fp_data[j-1][3] > fp_data[j][3]) do
   fp_data[j-1],fp_data[j] = fp_data[j],fp_data[j-1]
   j = j-1
  end
 end
end

function fp_draw(et)
    et = et or t
    local a,b,c,d,dist,col
    for i=1,fp_num do
     dist = (fpls[i][1][3] + fpls[i][2][3] + fpls[i][3][3] + fpls[i][4][3])/4
     col = fpcols[flr((1-abs((dist+50)/50))*#fpcols)+1] 
     a=p3t2(fpls[i][1])
     b=p3t2(fpls[i][2])
     c=p3t2(fpls[i][3])
     d=p3t2(fpls[i][4])
     line(a[1],a[2],b[1],b[2],col)
     line(a[1],a[2],c[1],c[2],col)
     line(a[1],a[2],d[1],d[2],col)
     line(b[1],b[2],c[1],c[2],col)
     line(b[1],b[2],d[1],d[2],col)
     line(c[1],c[2],d[1],d[2],col)
    end
end


function fp_update(et)
  et = et or t
  local a,b,c,d,pd,po,mr
  fpls,po,mr={},{},(et/600+1)
  for i=1,fp_num do
   pd = fp_data[i]
   po={}
   --gen/rotate, scale, translate, +? 2d, add
   add(po,rotate3d({1,0,0,0},{0,0,0},pd[4]*mr,pd[5]*mr,pd[6]*mr))
   add(po,rotate3d({-1,1,1,0},{0,0,0},pd[4]*mr,pd[5]*mr,pd[6]*mr))
   add(po,rotate3d({-1,-1,1,0},{0,0,0},pd[4]*mr,pd[5]*mr,pd[6]*mr))
   add(po,rotate3d({-1,0,-1,0},{0,0,0},pd[4]*mr,pd[5]*mr,pd[6]*mr))
   for j=1,4 do
    po[j]=translate3d(scale3d(po[j],pd[7],pd[7],pd[7]),-10+(pd[1]+pd[1]*(1-1.5*shore((et+i)/400)))+et/8,pd[2],pd[3]) --mod last 3 for motion
   end
   add(fpls,po)
  end
end

------------- line ribbon
lr_data={64,3}
lr_fills={0,0x8020,0x8421,0xA4A1,0xa5a5,0xada7,0xbde7,0xbfef,0xffff}
lr_cols={80,53,179,107,118}
function lr(et)
    et = et or t
    local angle = et/100
    local width = 10
    local fl = 0
    local cl = 0
    local noff = 30
    local w,p,a,l,s1,e1,s2,e2,swrl
    l = lr_data[1]*2
    for i=-noff,l do
      p = (i+noff)/(l+noff)*#lr_cols
      cl = lr_cols[flr(p)+1]
      fl = flr((p%1)*#lr_fills)
      fillp(lr_fills[fl+1])

      w=(2*width)*(l-i)/(l)
      swrl = (et/3000)
      a = angle * (l-i)/(l) * ((1+fsin(i/100+ et/1000)) *swrl + (1-swrl)) 

      s1 = rot2d((i/2)-64,-w,a)
      e1 = rot2d((i/2)-64,w,a)
      s2 = rot2d((i/2)-64,-w,a+.25)
      e2 = rot2d((i/2)-64,w,a+.25)

      line(s1[1]+64,s1[2]+64,e1[1]+64,e1[2]+64,cl)
      line(64-s1[1],64-s1[2],64-e1[1],64-e1[2],cl)

      line(s2[1]+64,s2[2]+64,e2[1]+64,e2[2]+64,cl)
      line(64-s2[1],64-s2[2],64-e2[1],64-e2[2],cl)

    end
end
------------- effect template
af={0xd7f7,0xada7,0xa5a5,0xa1a4,0x8204,0x200}
function astetic(et)
 et = et or t
 for i=1,16 do
  fillp(af[abs(flr(#af*sin(i/16+.5+et/200)))+1])
  rectfill(0,(i-1)*8,128,i*8,236)
 end
end

---------------- style arrows
-- x,y,size (speed from size)
arrowsp={}
function genarrow()
 local p = {rnd(196)-32,128,flr(rnd(2))/2 + .5}
 return p
end
function arrows_init()
 arrowsp = {}
 local ap
 for i=1,6 do
  ap = {rnd(196)-32,rnd(196)+128,flr(rnd(4)/2)+.5}
  add(arrowsp,ap)
 end
end

function arrows(et)
    et = et or t
 pal(7,15)
 for i=1,#arrowsp do
  --spr()
  sspr(96,32,32,32,arrowsp[i][1],arrowsp[i][2],32*arrowsp[i][3],32*arrowsp[i][3])
 end
 pal()
end

function arrows_update()
 for i=1,#arrowsp do
  arrowsp[i][2] -= arrowsp[i][3]
  if arrowsp[i][2] < -32 then
   arrowsp[i] = genarrow()
  end
 end
end


----------------- ball thing
bto={}
btd={}
btnslices = 13
function bt_init()
 local slc = {}
 local points,r,dc,p
 bto = {}
 -- from 0?
 for i = 1,btnslices do
  slc = {}
  dc = abs((btnslices/2)-i)
  -- number of points per slice is number of slices - diff from center slice
  points = 4 + btnslices - dc
  for j = 1, points do
   p={}
   r = 10 * cos((dc/(btnslices/2))*.2) + rnd(10)/10 -.5
   p[1] = r * sin(j/points)
   p[2] = r * cos(j/points)
   p[3] = (i - (btnslices/2)) * 1.5
   add(slc,p)
  end
  add(bto,slc) 
 end
end

function bt(et)
 et = et or t
 local slc={}
 local p1,p2
 
 -- draw lines between each point on a slice
 for i=1,btnslices do
  slc = btd[i]
  
  -- do end point for wrapping
  p2 = p3t2(slc[#slc])
  for j=1,#slc do
   p1 = p2
   p2 = p3t2(slc[j])
   line(p1[1],p1[2],p2[1],p2[2],6)
   -- and some circles
   if(i+j)%5 == 0 then
    circ(p1[1],p1[2],1 + 100/slc[j][3],13)
   end
  end
 end
end

function bt_update(et)
 local pr,pt,ps,s
 local slc,nslc={},{}
 et = et or t
 
 if t%10 ==0 then
  --bt_init()
 end
 btd = {}
 for i=1,btnslices do
  slc = bto[i]
  nslc={}
  for j=1,#slc do
   pr = rotate3d(bto[i][j],cent,0.3,0,et/400)
   s = fsin((i/16)/4 + et/60)
   ps = scale3d(pr,2+.5*sin(i/btnslices + et/240),2,2)
   pt = translate3d(ps,10-0.1*clamp((et-pattern_time*80),0,700),4,40)
   add(nslc,pt)
  end
  add(btd,nslc)
 end
end


------------------- utils
-- fast sin
function fsin(i)
 return sint[flr(i*stn)%stn+1]
end
--[[
function fps()
  local p = flr((1/stat(1))*60)
  if p >= 60 then
   print("fps:"..p,0,0,0)
  else
   print("fps:"..p,0,0,8)
  end
 end
 --]]
function rot2d(x,y,a)
  local r = {0,0}
  local s = fsin(a)
  local c = fsin(a+1/4)
  r[1] = x * c - y * s
  r[2] = x * s + y * c
  return r
end

function smootherstep(e0,e1,x)
  x = clamp((x-e0)/(e1-e0),0,1)
  return x*x*x*(x*(x*6-15)+10)
end
function clamp(x, ll, ul)
 if x < ll then x = ll elseif x > ul then x = ul end
 return x
end

fshore = {}
fshore_num = 1000
function fshore_init()
  local onepolez = 0
  local s
  for i = 1,fshore_num do
   add(fshore,0)
  end
  for i = 1,fshore_num*2 do
   s = (1- (i%fshore_num/fshore_num))
   s = s*s
   onepolez =(s * 0.01) + (onepolez * 0.99)
   fshore[i%fshore_num]=onepolez
  end
end

-- p = 0->1 /``**-._
function shore(p)
 local s
 s = fshore[flr(p%1 * fshore_num)]
 return s
end
-------------

-->8
-- a newskool font renderer
-- by gasman

-- decode string to an array of ints 0..63
charset = '0123456789abcdefghijklmnopqrstuvwxyz-_+[]{}|:;=.<>?/~`!@#$%^&*()'
char2num = {}
for i=1,#charset do
  char2num[sub(charset, i, i)] = i-1
end

function decode(s)
  a = {}
  for i=1,#s do
    a[i] = char2num[sub(s, i, i)]
  end
  return a
end

fontstr = '|appfb<0l_m_.apmc80gatoa7mwlfwtval[gbgwaf{89<0al{e9w<a].33w<l]?|? ;arwhi00la0a? }apwiikc |apwhi00l}0}? :l7w|wapwiikg olc6c?l4fmfai766<0ailkk03 }aovhh00l{e{/ap>geg= {la0a?aptff<gl]t]? bla0a7laea? bla0a7laea#a3#76gwl1(3( }l919?l9_{ells{? bla0a? )laea?antdf<ga>tdf<gl-t-?l(t(? {laea?apqfc<gl]q]? :apwii00 ;arwhi00laea( |apwhi00l}e}( rlaea?apsfe<1 [anpeb0gaonf9]0lpwdtap{d90yao+hcw< nld3d:l4fnfak:75t< {ap-feg<l]e]?laea- +l4el/l_el/ *l4ei/lwei/lwe=/l&e=/ [l6e+/l_e4/ +l4em?l_ej$a9#a5hw _l7f-flzf4?l4?_? f'

-- split fontstr on spaces, and decode each resulting substring
font = {}
chars = 'abcdefghijklmnopqrstuvwxyz '
c = 1
start = 1

for i=1,(#fontstr+1) do
  if i > #fontstr or sub(fontstr,i,i) == ' ' then
    font[sub(chars, c, c)] = decode(sub(fontstr, start, i-1))
    c += 1
    start = i+1
  end
end

function arc(cx, cy, rx, ry, a1, a2, clr)
  if a2<=a1 then a2 += 1 end
  for t=a1,a2,0.01 do
    pset(cx-rx*sin(t), cy-ry*cos(t), clr)
  end
end

function drawchar(char, x, y, xsize, clr)
  i = 2
  d = font[char]
  ysize = xsize*1.15

  while i <= #d do
    if d[i] == 10 then -- arc
      arc(x+d[i+1]*xsize,y+d[i+2]*ysize,d[i+3]*xsize,d[i+4]*ysize,d[i+5]/64,d[i+6]/64, clr)
      i += 7
    else -- line
      line(x+d[i+1]*xsize,y+d[i+2]*ysize,x+d[i+3]*xsize,y+d[i+4]*ysize, clr)
      i += 5
    end
  end
end

function drawstring(s, cx, y, xsize, kern, clr)
  width = 0
  for i=1,#s do
    char = sub(s,i,i)
    width += font[char][1]
  end

  x = 0
  for i=1,#s do
    char = sub(s,i,i)
    drawchar(char, cx+(x-width/2)*xsize*kern, y, xsize, clr)
    x += font[char][1]
  end
end

textpal = decode('6d5005d6')
function animtext(s, x, y, xsize, starttime)
  local t = (time() - starttime) / 3
  if t >= 0 and t < 1 then
    drawstring(s, x, y, xsize, t*1.2 + 0.6, textpal[flr(t*8)+1])
  end
end

-->8
-- 4 way expertiments

function drawstringv(s, cx, y, ysize, kern, clr)
  for i=1,#s do
    char = sub(s,i,i)
    drawchar(char, cx, y+(i-1)*kern, ysize, clr)
  end
--[[
  local height = 0
  for i=1,#s do
    char = sub(s,i,i)
    height += font[char][1]
  end

  local my = 0
  for i=1,#s do
    char = sub(s,i,i)
    drawchar(char, cx, y+(my-height/2)*xsize*kern, xsize, clr)
    my += font[char][1]
  end
--]]
end


------------- effect template
function arcs_init()
 -- go 4 way
 poke(0x5f2c, 7)

 -- go back
 --poke(0x5f2c, 0)
end

arcspal={0,1,5,13,12,6,7,6,12,13,5,1,0}

function arcs(et)
    et = et or t
 local x1,l,c,xs
 fillp(0xa5a5)
 for i = 0,64 do
  x1 = 1 - i/64
  xs = x1 + t/100
  x1*=x1
  if x1 > et%1 then
   x1=.7*x1+ .2*sin(2*xs)+.1*cos(xs)
  else
   x1=.7*x1+ .2*cos(2*xs)
  end 
  x1*=64
  x1-=20
  l=10
  c=0
  for j=x1,64,l do
   c+=1
   line(x1+c*l,i,x1+c*l+l,i,arcspal[c]+arcspal[c+1]*16)
  end
 end
end

-- invert palette
ip = decode('071f2d3e4c568a9b')
function invertpal()
  for i=1,16 do
    pal(ip[i],ip[i+1])
    pal(ip[i+1],ip[i])
    i+=1
  end
end

-->8
-- polytest stuff
-- todo: y==0 in points is causing a bug, fix

-- draw lines between 2 line{points}


fls={0,0x1040,0x5050,0x4a52,0xa5a5,0xda7a,0xbe7d,0xfdf7,0xffff}
mats={{1,193},{2,101}}
------------------ tetrahedron etc

-- additional object to rotate around tetra or otherway round
starv={{0,-2,0},{-1,0,-1},{-1,0,1},{1,0,1},{1,0,-1}}
starp={{1,2,5},{1,4,3},{1,5,4},{1,3,2}, {4,5,2},{2,3,4}}
staro={}
stard={}
function starv_init()
  local p1,p2,p3,m,poly
  for i = 1,#starp do
   p1 = starv[starp[i][1]]
   p2 = starv[starp[i][2]]
   p3 = starv[starp[i][3]]
   m = mats[2]
   poly = {p1,p2,p3,m}
   add(staro,poly)
  end
end
function tetra2_update()
  local poly,pr,ps,pt,npoly
  stard = {}
  tetrad = {}
  -- rotate,scale,transform tetra
  for i=1,#tetrao do
   poly = tetrao[i]
   npoly={}
   for j=1,#poly-1 do
    pr = rotate3d(poly[j],cent,0,-t/500,-t/1000)
    ps = scale3d(pr,8,8,8)
    pt = translate3d(ps,0.1,0.1,30+5*fsin(t/2000))
    add(npoly,pt)
   end
   -- add mat
   add(npoly,poly[#poly])
   add(tetrad,npoly)
  end

  -- rotate,scale, multi transform and add star
  for i=1,#staro do
    poly = staro[i]
    npoly={}
    for j=1,#poly-1 do
--      pr = rotate3d(poly[j],cent,0.05,-t/400,0.4)
      pr = rotate3d(poly[j],cent,0.05,0,0.4)
      --ps = scale3d(pr,1.5,1.5,1.5)
      add(npoly,pr)
    end
    -- add mat
    add(npoly,poly[#poly])
    add(stard,npoly)
  end
  
  for i=1,6 do
    for j=1,#stard do
      poly = stard[j]
      npoly={}
      for k=1,#poly-1 do
        pt = translate3d(poly[k],0.1+14,0.1,0)
        pr = rotate3d(pt,cent,-t/1000,(-t/400)+i/6,0)
        pt = translate3d(pr,0,0,30+5*fsin(t/2000))
        add(npoly,pt)
      end
      -- add mat
      add(npoly,poly[#poly])
      add(tetrad,npoly)
    end
  end

  -- do world/camera shit if you have too...
  zsort(tetrad)
  
 end
 

tetrav={{0,1,0},{0,-1,0},{-1,0,0},{1,0,0},{0,0,-1},{0,0,1}}
tetrap={{1,5,3},{1,3,6},{1,4,5},{1,6,4},{2,3,5},{2,6,3},{2,5,4},{2,4,6}}
tetram={1,2,3,4,5,6,7,8}
tetrao={}
tetrad={}
function tetra_init()
 local p1,p2,p3,m,poly
 for i = 1,#tetrap do
  p1 = tetrav[tetrap[i][1]]
  p2 = tetrav[tetrap[i][2]]
  p3 = tetrav[tetrap[i][3]]
  m = mats[1]
  poly = {p1,p2,p3,m}
  add(tetrao,poly)
 end
end

function tetra(et)
 -- 2d points
 local p1,p2,p3
 -- 3d vectors
 local v1,v2,v3
 -- material (in case shading)
 local f,c,cnt,n,nd
 et = et or t
 cnt = 0

 -- for each poly
 for i=1,#tetrad do
  v1 = tetrad[i][1]
  v2 = tetrad[i][2]
  v3 = tetrad[i][3]
  p1 = p3t2(v1)
  p2 = p3t2(v2)
  p3 = p3t2(v3)
  
  f = tetrad[i][4][1]

  c = tetrad[i][4][2]
  nd = normal(v1,v2,v3)
  f = 1+flr(-nd.z*9)

  -- backface culling off normal
  if nd.z < 0 then
   drawtri(p1[1],p1[2],p2[1],p2[2],p3[1],p3[2],fls[f],c)
   cnt+=1
  end
 end  
end

function tetra_update()
 local poly,pr,ps,pt,npoly
 tetrad = {}
 -- rotate,scale,transform object
 for i=1,#tetrao do
  poly = tetrao[i]
  npoly={}
  for j=1,#poly-1 do
--   pt = translate3d(poly[j],-2,-1,-2)
   pr = rotate3d(poly[j],cent,0,-t/500,-t/1000)
   ps = scale3d(pr,8,8,8)
   pt = translate3d(ps,0.1,0.1,20)
   add(npoly,pt)
  end
  -- add mat
  add(npoly,poly[#poly])
  add(tetrad,npoly)
 end
 -- do world/camera shit if you have too...
 zsort(tetrad)
end


-- draw list of triangles
function drawtris(tris)
 drawtri(8,25,0,20,10,10,0xa5a5,40)
end

-->8
-- mt's 3d engine

cent={0,0,0,0}
------------- 3d basics
function rotate3d(p3d,center,ax,ay,az)
	local a,b,c,a1,b1,c1,a2,b2,c2,a3,b2,c3,ac,as,bc,bs,cc,cs
	local np3d={0,0,0,0}

	a = p3d[1]-center[1]
	b = p3d[2]-center[2]
	c = p3d[3]-center[3]
  
  as = sint[flr(az*stn)%stn+1]
	ac = sint[(60+flr(az*stn))%stn+1]
	a1 = a*ac-b*as 
    b1 = a*as+b*ac
	c1 = c

	bs = sint[flr(ay*stn)%stn+1]
	bc = sint[(60+flr(ay*stn))%stn+1]
	c2 = c1*bc-a1*bs 	
	a2 = c1*bs+a1*bc
    b2 = b1
	
  cs = sint[flr(ax*stn)%stn+1]
	cc = sint[(60+flr(ax*stn))%stn+1]
	b3 = b2*cc-c2*cs 	
	c3 = b2*cs+c2*cc
    a3 = a2		
			
	np3d[1]=a3-center[1]
	np3d[2]=b3-center[2]
	np3d[3]=c3-center[3]
	np3d[4]=p3d[4]
	return np3d
end
function translate3d(p3d,ax,ay,az)
	local np3d={0,0,0,0}
	np3d[1]=p3d[1]+ax
	np3d[2]=p3d[2]+ay
	np3d[3]=p3d[3]+az
	np3d[4]=p3d[4]
	return np3d
end
function scale3d(p3d,ax,ay,az)
	local np3d={0,0,0,0}
	np3d[1]=p3d[1] * ax
	np3d[2]=p3d[2] * ay
	np3d[3]=p3d[3] * az
	np3d[4]=p3d[4]
	return np3d
end

fov = 90
-- 3d point to 2d point
function p3t2(p)
 local p2d={}
	local x2d = fov * p[1] / p[3]
	local y2d = fov * p[2] / p[3]
	
	x2d = x2d + 64 --center w
	y2d = y2d + 64  --center h
	
 p2d[1] = x2d
 p2d[2] = y2d
 return p2d
end

------------------ useful math
-- take in an array of tri's {x,y,z,m}, return an
function zsort(ps)
 for i=1,#ps do
  local j = i
  while j > 1 and zsortp(ps[j-1],ps[j]) do
   ps[j-1],ps[j] = ps[j],ps[j-1]
   j = j-1
  end
 end
end

function zsortp(p1,p2)
	return (p1[1][3]+p1[2][3]+p1[3][3])<(p2[1][3]+p2[2][3]+p2[3][3])
end

function cprod(ax,ay,az,bx,by,bz)
  r = {x=(ay*bz)-(az*by),y=(ax*bz)-(az*bx),z=(ax*by)-(ay*bx)}
   return r
end

function normalize(v)
 local nv,sum
 sum = sqrt(v.x*v.x + v.y*v.y + v.z*v.z)
 nv = {x=v.x/sum,y=v.y/sum,z=v.z/sum}
 return nv
end

function normal(p1,p2,p3)
  ax = p2[1] - p1[1]
	ay = p2[2] - p1[2]
	az = p2[3] - p1[3] 

  bx = p3[1] - p1[1]
	by = p3[2] - p1[2] 
	bz = p3[3] - p1[3] 
		
	return normalize(cprod(ax,ay,az,bx,by,bz))
end

-------- draw trianle functions
function drawtritop(x0,y0,x1,y1,x2,f,c)
  local h,dx1,dx2,lx1,lx2
  -- get points on (x0,y0) -> (x1,y1) and (x0,y0) -> (x2,y1)
  h=y1-y0
  dx1=(x1-x0)/h
  dx2=(x2-x0)/h
  lx1,lx2 = x0,x0
  fillp(f)
  for y = y0,y1 do
    -- line between
    line(lx1,y,lx2,y,c)
    lx1+=dx1
    lx2+=dx2
  end
  --fillp()
end

function drawtribot(x0,y0,x1,x2,y2,f,c)
  local h,dx1,dx2,lx1,lx2
  -- get points on (x0,y0) -> (x2,y2) and (x1,y0) -> (x2,y2)
  h=y2-y0
  dx1=(x2-x0)/h
  dx2=(x2-x1)/h
  lx1,lx2 = x0,x1
  fillp(f)
  for y = y0,y2 do
    -- line between
    line(lx1,y,lx2,y,c)
    lx1+=dx1
    lx2+=dx2
  end
  --fillp()
end

-- draw tri
function drawtri(x0,y0,x1,y1,x2,y2,f,c)
  local lx0,ly0,lx1,ly1,lx2,ly2,nx,ny
  if y0 == 0 then y0 = 0.1 end
  if y1 == 0 then y1 = 0.1 end
  if y2 == 0 then y2 = 0.1 end

  -- sort points
  if y1<y0 then x0,y0,x1,y1 = x1,y1,x0,y0 end
  if y2<y0 then x0,y0,x2,y2 = x2,y2,x0,y0 end
  if y2<y1 then x1,y1,x2,y2 = x2,y2,x1,y1 end
  
  -- check if flat
  if y0==y1 then
    drawtritop(x0,y0,x1,y1,x2,f,c)
  elseif y1==y2 then
    drawtribot(x0,y0,x1,x2,y2,f,c)
  else
    -- get new point
    --ny = ly1
    nx = x0 + (((y1 - y0)/(y2 - y0)) * (x2-x0))
    -- 2 draws
    drawtritop(x0,y0,x1,y1,nx,f,c)
    drawtribot(x1,y1,nx,x2,y2,f,c)
  end
end

-->8
-- chunky sphere
cs_texture = {}
cs_screen_map = {}
cs_specular_map = {}

cs_satellites = {}
cs_satellite_params = {
  {-0.05, 0},
  {-0.2, 0.4}, {-0.2, 0.44}, {-0.2, 0.48},
  {-0.3, 0.6}, {-0.7, 0.8}
}

cs_texturestr = 'jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjggggggggggggggghhhhhhhhhhhhiiiiiiiiiiijjjjjjjjjjjjjjkkkkkkkkkkkkkkkkllllllllllllllllllkkkkkkkkkkjjjjjjjiiiiiihhhhhhhhgggggggggggbcccccccdddddeeeeeffffffgggggghhhhhhhhhiiiiiiiiiiiijjjjjjjjjjjkkkkkkkkkklllllllllllllllllllkkkkjjjiiihhhggfffeeedddccccccbbbbbbb77888999aaabbbccccdddddeeeefffffgggggghhhhhhhhhhhhhhhhhiiiiiiiiiiiiiiiiiiiijjjjjkkkkkkkkkkkkjjjiiihhgffeedccbaa998887777666667774556677888999aaaaaabbbbccccdddeeefffgggghhhhhhhhhhhhhggggggggggfffffffeeefffffggghhhiiiiijjiiiihhgffedccba98876654433332222333444556777888899888888899999aabbccddeffgghhhiiiiihhhhhgggggfffffeeedddcccbbbbbbbbccddeeffggghhhhhggffeddcba98776543322111111111223367789999999988777666666677899abcdefghhijjjjjjjjiihhhgggffffeeedddccbbbaa9999999aabbccdeeffggggfffeddcbba987655433222111222233455aabbcccccba9876654433344456789abdefhijkllmmmllkkjiihggffffeeeeeeedddccbbbaa99999aaabccddeeefffeeeedddcbba98765544333344455667889defffgffedcb986543221122344678abdegijlmnoopoonnmlkjihggffffffffffffffffeeddcccbbbbbbcccddddddddddddddccbba98765544455667899abccdghiijjjiigfdb97543211112234578abdfhjlnopqrrrrqponlkjihggfffffggghhiiiiiiiihggffeeddddccccccbbbbbbbbbccbba987655444456689abcddefghijkllmmlkiheca864322223345679acdfhjlnprsstttsrqpnmkjihggfffgghhijjkllllllkkjihhgfeeddccbba9988888899aa99876543333345678abcdefggghjklmnoonmkigeb97654444556789bcefhjlnpqsttuutsrqpnmkjihhggggghhijkllmnnnnmllkjihggfeedcba9876555556777776654321112345679abccdefefhikmnopponljhfdb98766666789abcdfgikmnpqrstttssqpomlkjihhgggggghijklmmnnnmmlkjihhgffeddba976543233445666654322111223457889aabccabdfhjlmnoonmljhfeca9876667789acdefhijlmopqrrrrqqpnmlkjihhggffffgghikllmmmmlkjiihggggfeecb98643211223456666543322233456778888889678adfhjklmmlljigedb9876555678abcefghijklmnooppponmlkjihhgffeeeeefghjklmnnmmlkjihgggggffdca975322122356778776655555677888877655533568bdfhijjjjihfeca8754444578acdegghhiijkllmnnnmmlkjihggfeddcccdefhjlmnooonmlkjihhggggfedba8654333456789aa99887778899aa99865432123468acefghhhgfecb9754434568aceghiijjjjjjkkllmllkjjihgfedccbbbbcdfhkmoprrrqpnmkjihhgggffecb98765556789bbccbba999999aabbba9764323334578acdffggfedca876555679bdgijkllllkkkkkkkkkkjjihgfeedcbbaaaacdfiknprtttsrpnlkihhggggfedcba9877899abcddccba9988899aabbba97643656678abdefggggfecba88788abdgikmnoooonmllkkkjjjihgfeddccbbaaaaabcegiloqsuuutsqomkjihhhhhggfedcbbaabbccddddcbba9877667789aaaa9876a9aabcdfghijjjihgfdcbbbcdegikmopqrrqponlkjiihggfedcbaaaaaaaaaabcdfhjmoqstuutsqonlkjjjjjjjjihhgfedddddeeeddcba98655444456789aaaaacddefghijklmmmlljihgffffgikmnpqrssrqpnmkjhgfedcba98888889aabbccdegikmoqrsssrqpomllkklmmnnnmmlkjihggffffeedcba976533222345679abbcdefghijklnnoooonmlkjiiiijkmnopqrrqqpnmkihfedcba9876667789abccdefghiklnoppqpponmllllmnopqqqqqponmkjihhgffeedcb9865432112235689acddeefghjklmnopppoonmlkkkkkllmnooooonmljihfedcba9877667789abcdeefgghijklmmmmmmllkkkllmopqrsssssrqonmkjihhgffedcb9865432222345789acbcdeefgijklmnnnnnmmlkkkjjkkklllllllkjihhgfedcba99888899abcddeeffgghiijjjjjjjjiijjklmnpqrssttssrqonmkjiihggfedcba876544444567889aabbccdefghijjkkkkkkkjjjjjjjjjkkkkkkkjjjihhgffedcbbbaaaabbbcccdddeeffggggghhhhhhiijklmnpqqrrrrrqponmlkjihhgffedcba988776667778899aaabbbcddeffghhiiijjjjjjjjkkkkllllmmllllkkjihhgfedccbbaaaaaaaaaaabbcccdddeeeffgghijklmmnoopppoonnmlkjjihhggffeddcbbaa9999999999abbbbbbcccdeefgghhiijjkkllmmmnnooooooooonnmlkjihgfedcbaa9887777777778899aabbccdeefghiijkkllmmmlllkkjjiihhggfffeedddcccbbbbbbbbbbbcccdddddeeffghhijjkllmnnooppqqqrrrrrqqpponmlkjihgedcba9876655444445556677889aabccdeffgghhiiiiiiiiihhhhgggfffffeeeeedddddddddddddfffffggghhhijjkklmmnooppqqrrrrssssrrrqqponmlkjihgedcba98765544433333444556677889aabbcddeeeffffffffffffffffffffffffffffffffffffffhhiiiijjjkkkllmmnnoopppqqqqqrrrrqqqppponnmlkjihggfedcba98876665554444455556667788899aabbbcccdddddeeeeeeeefffffffffffgggggggghhhhijjjjkkkkllllmmmmnnnnnooooooooonnnnmmmllkkjjihhggfeedccbbaa9998888777777777888889999aaaabbbbccccdddddeeeeeeffffffgggggghhhhhiiiiiiiiijjjjjjjjjjkkkkkkkkkkkkkkkjjjjjjiiiiihhhhggggfffeeeedddddccccccbbbbbbbbbbbbbbbbcccccccccdddddddeeeeeeeffffffggggggghhhhhhhiiggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggcccbbbbbbbbbbbbbbbbcccccccccdddddddeeeeeeeffffffggggggghhhhhhhiiiiiiijjjjjjjjjjkkkkkkkkkkkkkkkjjjjjjiiiiihhhhggggfffeeeedddddccc88777777777888889999aaaabbbbccccdddddeeeeeeffffffgggggghhhhhiiiiijjjjkkkkllllmmmmnnnnnooooooooonnnnmmmllkkjjihhggfeedccbbaa9998854444455556667788899aabbbcccdddddeeeeeeeefffffffffffgggggggghhhhhhiiiijjjkkkllmmnnoopppqqqqqrrrrqqqppponnmlkjihggfedcba9887666553333444556677889aabbcddeeefffffffffffffffffffffffffffffffffffffffffffggghhhijjkklmmnooppqqrrrrssssrrrqqponmlkjihgedcba9876554443445556677889aabccdeffgghhiiiiiiiiihhhhgggfffffeeeeedddddddddddddcccdddddeeffghhijjkllmnnooppqqqrrrrrqqpponmlkjihgedcba98766554447778899aabbccdeefghiijkkllmmmlllkkjjiihhggfffeedddcccbbbbbbbbbbbbbbbbbcccdeefgghhiijjkkllmmmnnooooooooonnmlkjihgfedcbaa988777777abbcccdddeeeffgghijklmmnoopppoonnmlkjjihhggffeddcbbaa9999999999aaaabbbcddeffghhiiijjjjjjjjkkkkllllmmllllkkjihhgfedccbbaaaaaaaaaaeeffggggghhhhhhiijklmnpqqrrrrrqponmlkjihhgffedcba988776667778899abbccdefghijjkkkkkkkjjjjjjjjjkkkkkkkjjjihhgffedcbbbaaaabbbcccdddgghiijjjjjjjjiijjklmnpqrssttssrqonmkjiihggfedcba876544444567889abcdeefgijklmnnnnnmmlkkkjjkkklllllllkjihhgfedcba99888899abcddeeffghijklmmmmmmllkkkllmopqrsssssrqonmkjihhgffedcb9865432222345789acdeefghjklmnopppoonmlkkkkkllmnooooonmljihfedcba9877667789abcdeefgghiklnoppqpponmllllmnopqqqqqponmkjihhgffeedcb9865432112235689acddefghijklnnoooonmlkjiiiijkmnopqrrqqpnmkihfedcba9876667789abccdefegikmoqrsssrqpomllkklmmnnnmmlkjihggffffeedcba976533222345679abbccddefghijklmmmlljihgffffgikmnpqrssrqpnmkjhgfedcba98888889aabbccddfhjmoqstuutsqonlkjjjjjjjjihhgfedddddeeeddcba98655444456789aaaaaa9aabcdfghijjjihgfdcbbbcdegikmopqrrqponlkjiihggfedcbaaaaaaaaaabccegiloqsuuutsqomkjihhhhhggfedcbbaabbccddddcbba9877667789aaaa9876656678abdefggggfecba88788abdgikmnoooonmllkkkjjjihgfeddccbbaaaaabcdfiknprtttsrpnlkihhggggfedcba9877899abcddccba9988899aabbba976433334578acdffggfedca876555679bdgijkllllkkkkkkkkkkjjihgfeedcbbaaaacdfhkmoprrrqpnmkjihhgggffecb98765556789bbccbba999999aabbba976432123468acefghhhgfecb9754434568aceghiijjjjjjkkllmllkjjihgfedccbbbbdefhjlmnooonmlkjihhggggfedba8654333456789aa99887778899aa9986543233568bdfhijjjjihfeca8754444578acdegghhiijkllmnnnmmlkjihggfeddcccefghjklmnnmmlkjihgggggffdca9753221223567787766555556778888776555678adfhjklmmlljigedb9876555678abcefghijklmnooppponmlkjihhgffeeeegghikllmmmmlkjiihggggfeecb98643211223456666543322233456778888889abdfhjlmnoonmljhfeca9876667789acdefhijlmopqrrrrqqpnmlkjihhggffffhijklmmnnnmmlkjihhgffeddba976543233445666654322111223457889aabccefhikmnopponljhfdb98766666789abcdfgikmnpqrstttssqpomlkjihhggggggijkllmnnnnmllkjihggfeedcba9876555556777776654321112345679abccdefghjklmnoonmkigeb97654444556789bcefhjlnpqsttuutsrqpnmkjihhggggghhijjkllllllkkjihhgfeeddccbba9988888899aa99876543333345678abcdefgghijkllmmlkiheca864322223345679acdfhjlnprsstttsrqpnmkjihggfffgghhhhiiiiiiiihggffeeddddccccccbbbbbbbbbccbba987655444456689abcddefgghiijjjiigfdb97543211112234578abdfhjlnopqrrrrqponlkjihggfffffgggfffffffeeddcccbbbbbbcccddddddddddddddccbba98765544455667899abccddefffgffedcb986543221122344678abdegijlmnoopoonnmlkjihggfffffffffedddccbbbaa99999aaabccddeeefffeeeedddcbba98765544333344455667889aabbcccccba9876654433344456789abdefhijkllmmmllkkjiihggffffeeeeeedccbbbaa9999999aabbccdeeffggggfffeddcbba98765543322211122223345567789999999988777666666677899abcdefghhijjjjjjjjiihhhgggffffeeedddddcccbbbbbbbbccddeeffggghhhhhggffeddcba9877654332211111111122334556777888899888888899999aabbccddeffgghhhiiiiihhhhhgggggfffffeeeffffffeeefffffggghhhiiiiijjiiiihhgffedccba98876654433332222333444556677888999aaaaaabbbbccccdddeeefffgggghhhhhhhhhhhhhggggggggggfiiiiiiiiiiijjjjjkkkkkkkkkkkkjjjiiihhgffeedccbaa9988877776666677777888999aaabbbccccdddddeeeefffffgggggghhhhhhhhhhhhhhhhhiiiiiiiiikkkkkkkklllllllllllllllllllkkkkjjjiiihhhggfffeeedddccccccbbbbbbbbcccccccdddddeeeeeffffffgggggghhhhhhhhhiiiiiiiiiiiijjjjjjjjjjjkkkkkkllllllllllllllllllkkkkkkkkkkjjjjjjjiiiiiihhhhhhhhgggggggggggggggggggggggggghhhhhhhhhhhhiiiiiiiiiiijjjjjjjjjjjjjjkkkkkkkkkkkk'

function cs_plot_sphere(cy, cx, mainr, tilt)
  for lat=0.5,63.5,0.1 do
    local sph_y = cos(lat/64)
    local r = sin(lat/64)

    -- local y = cy + mainr*sph_y

    for lng=0,127.5,0.4 do
      local sph_x = r * cos(lng/128)
      local sph_z = r * sin(lng/128)

      local sphr_y = sph_y * cos(tilt) + sph_z * sin(tilt)
      local sphr_z = sph_z * cos(tilt) - sph_y * sin(tilt)

      local sx = flr(cx + mainr*sph_x)
      local sy = flr(4*(cy + mainr*sphr_y))
      -- local z = mainr*sph_z

      if sphr_z < 0 and sy >= 0 and sy < 256 and sx >= 0 and sx < 32 then
        cs_screen_map[sy][sx] = {lng, lat}
        cs_specular_map[sy][sx] = 12 * max(0, cos(lng/64 - 0.3)^3)
      end
    end
  end
end

function cs_init()
  palt(0, false)
  palt(14, true)

  for y=0,256 do
    cs_screen_map[y] = {}
    cs_specular_map[y] = {}
  end
  cs_plot_sphere(44, 8.5, 15, 0.12)
  cs_plot_sphere(18.5, 24.5, 8, 0.12)

  for y=0,63 do
    cs_texture[y] = {}
    row = decode(sub(cs_texturestr, y*128+1, y*128+128))
    for x=0,127 do
      cs_texture[y][x] = row[x+1]
    end
  end

end

cs_tex_x = 0
cs_scr_y = -80
cs_sat_pos = 0

function cs_update()
  cs_tex_x += 0.5
  cs_scr_y += 0.2
  cs_sat_pos -= 0.005
end

function cs_draw()
  rectfill(0, 0, 127, 127, 5)

  local text_y = cs_scr_y * 0.4 - 20
  drawstring('a new', 64, -8 - text_y, 0.60, 1, 13)
  drawstring('star', 64, 20 - text_y, 0.65, 1, 13)
  drawstring('in the', 64, 60 - text_y, 0.5, 1, 13)
  drawstring('sky', 84, 80 - text_y, 0.75, 1, 13)

  for y=0,31 do
    local sy = y*4 + cs_scr_y
    local row = cs_screen_map[flr(sy)]
    if row then
      for x=0,31 do
        ll = row[x]
        if ll then
          val = cs_texture[flr(ll[2]) % 64][flr(ll[1] + cs_tex_x) % 128] + cs_specular_map[flr(sy)][x] +1
        else
          val = 0
        end

        mset(
          bor(shr(x,1), shl(band(x,1), 4)),
          bor(shr(y,1), shl(band(y,1), 4)),
          val
        )
      end
    end
  end

  for i = 1,#cs_satellite_params do
    local sp = cs_satellite_params[i]
    local sat_y = 72 * sin(cs_sat_pos + sp[2])
    cs_satellites[i] = {
      34 + sin(sp[1])*sat_y,
      176 - cs_scr_y + cos(sp[1]) * sat_y,
      cos(cs_sat_pos + sp[2])
    }
  end

  for s in all(cs_satellites) do
    if s[3] < 0 then
      spr(80, s[1]-8, s[2]-8,2,2)
    end
  end

  map(0,0,0,0,16,16)
  map(16,0,4,0,16,16)
  map(0,16,0,4,16,16)
  map(16,16,4,4,16,16)

  for s in all(cs_satellites) do
    if s[3] >= 0 then
      spr(80, s[1]-8, s[2]-8,2,2)
    end
  end

  --print(stat(1), 0, 0, 10)
end

-->8
-- tree
-- by gasman

tree_t = 0

tree_vertices = {}
tree_edges = {}
tree_leaves = {}
transformed_tree_vertices = {}

blossoms = {}
transformed_blossom_vertices = {}
floor_blossoms = {}

blossom_hide_time = 700

tree_view_angle = 0.20

function rota_axis(v, axis, r)
  -- rotate vector v about axis by r revolutions
  -- see 5.2 at https://sites.google.com/site/glennmurray/Home/rotation-matrices-and-formulas/rotation-about-an-arbitrary-axis-in-3-dimensions

  local cosr, sinr = cos(r), sin(r)
  local a = (axis[1]*v[1] + axis[2]*v[2] + axis[3]*v[3]) * (1 - cosr)
  return {
    axis[1]*a + v[1]*cosr + (-axis[3]*v[2]+axis[2]*v[3])*sinr,
    axis[2]*a + v[2]*cosr + (axis[3]*v[1]-axis[1]*v[3])*sinr,
    axis[3]*a + v[3]*cosr + (-axis[2]*v[1]+axis[1]*v[2])*sinr
  }
end

function build_tree(depth, origin, origin_vertex_index, up, axis, scale)
  local next_origin = {
    origin[1] + scale * up[1],
    origin[2] + scale * up[2],
    origin[3] + scale * up[3]
  }
  add(tree_vertices, next_origin)
  local next_origin_vertex_index = #tree_vertices
  add(tree_edges, {origin_vertex_index, next_origin_vertex_index, depth})

  if depth > 1 then
    local branch_angles = ({
      {0, 0.5},
      {0, 0.33333, 0.66666},
      {0, 0.25, 0.5, 0.75}
    })[flr(rnd(3)) + 1]
    local base_rota = rnd(1)

    for r in all(branch_angles) do

      local new_axis = rota_axis(axis, up, base_rota + r)
      local new_up = rota_axis(up, new_axis, 0.07 + rnd(0.05))
      build_tree(depth-1, next_origin, next_origin_vertex_index, new_up, new_axis, scale * (0.7 + rnd(0.2)))

    end
  else
    if rnd(1) > 0.1 then
      add(tree_leaves, next_origin_vertex_index)
    else
      add(blossoms, {
        {next_origin[1], next_origin[2], next_origin[3]},
        425 + next_origin[1] * 20 + rnd(10), -- release time
        {-0.035-rnd(0.02), rnd(0.01)-0.005, rnd(0.01)-0.002}  -- release vector
      })
    end

    if rnd(1) < 0.1 then
      add(floor_blossoms, {next_origin[1], 0, next_origin[3]})
    end
  end
end

function tree_init()
  srand(3)
  local origin = {0, 0, 0}
  add(tree_vertices, origin)
  build_tree(6, origin, 1, {0, 1, 0}, {0, 0, 1}, 1)
end

tree_screen_scale = 24
tree_screen_x = 54 -- nominally 80
tree_screen_y = 128 -- nominally 96

function tree_update()
  tree_t += 0.5
  tree_view_angle = (tree_view_angle - 0.0010) % 1

  -- tree_screen_scale -= 0.015
  tree_screen_x += 0.03
  tree_screen_y -= 0.02

  for b in all(blossoms) do
    if tree_t > b[2] then
      b[1][1] += b[3][1]
      b[1][2] += b[3][2]
      b[1][3] += b[3][3]
    end
  end
end

function tree_transform(v)
  return {
    v[1] * cos(tree_view_angle) + v[3] * sin(tree_view_angle),
    v[2],
    v[3] * cos(tree_view_angle) - v[1] * sin(tree_view_angle)
  }
end

function tree_spr(n, v)
  spr(n, tree_screen_x+tree_screen_scale*v[1]-4, tree_screen_y-tree_screen_scale*v[2]-4)
end

tree_text = 'fallequalswinter'

function tree_draw()
  -- rectfill(0, 0, 127, 87, 1)
  -- rectfill(0, 88, 127, 127, 3)
  rectfill(0, 0, 127, tree_screen_y-9, 1)
  rectfill(0, tree_screen_y - 8, 127, 128, 3)

  -- drawstring('fallequalswinter', -28 + tree_text_x, tree_screen_y-118, 0.20, 1, 12)
  -- drawstring('winterspringseternal', -28 + tree_text_x, tree_screen_y-98, 0.20, 1, 12)

  for i=1,#tree_vertices do
    transformed_tree_vertices[i] = tree_transform(tree_vertices[i])
  end

  for i=1,#floor_blossoms do
    local tv = tree_transform(floor_blossoms[i])
    spr(114, tree_screen_x+tree_screen_scale*tv[1]-4, tree_screen_y-tree_screen_scale*tv[2] - tv[3]*1.5 -4)
  end

  if tree_t < blossom_hide_time then
    for i=1,#blossoms do
      local b = blossoms[i]
      transformed_blossom_vertices[i] = tree_transform(b[1])
    end

    for v in all(transformed_blossom_vertices) do
      if v[3] > 0 then
        tree_spr(114, v)
      end
    end
  end

  for i in all(tree_leaves) do
    v = transformed_tree_vertices[i]
    if v[3] > 0 then
      tree_spr(115, v)
    end
  end

  for e in all(tree_edges) do
    local v1,v2 = transformed_tree_vertices[e[1]], transformed_tree_vertices[e[2]]

    local sv1x, sv1y, sv2x, sv2y = tree_screen_x+tree_screen_scale*v1[1], tree_screen_y-tree_screen_scale*v1[2], tree_screen_x+tree_screen_scale*v2[1], tree_screen_y-tree_screen_scale*v2[2]

    if e[3] == 6 then
      line(sv1x-2, sv1y, sv2x-1, sv2y, 4)
      line(sv1x-1, sv1y, sv2x-1, sv2y, 4)
      line(sv1x, sv1y, sv2x, sv2y, 4)
      line(sv1x+1, sv1y, sv2x+1, sv2y, 4)
    elseif e[3] == 5 then
      line(sv1x-1, sv1y, sv2x-1, sv2y, 4)
      line(sv1x, sv1y, sv2x, sv2y, 4)
    else
      line(sv1x, sv1y, sv2x, sv2y, 4)
    end
  end

  for i in all(tree_leaves) do
    v = transformed_tree_vertices[i]
    if v[3] <= 0 then
      tree_spr(112, v)
    end
  end

  if tree_t < blossom_hide_time then
    for v in all(transformed_blossom_vertices) do
      if v[3] <= 0 then
        tree_spr(113, v)
      end
    end
  end

  for i=1,#tree_text do
    local letter_t=tree_t-60-10*i
    if letter_t > 0 then
      drawchar(sub(tree_text, i, i), 24+16*sin(i*0.31), 128-((letter_t*0.06)^2), 0.2, 15)
    end
  end
end

__gfx__
000000001111eeee1111eeee3111eeee3111eeee3131eeee3131eeee3131eeee3131eeee3131eeee3131eeee3331eeee3331eeee3333eeee3333eeee3333eeee
000000001111eeee1111eeee1111eeee1111eeee1111eeee1111eeee1311eeee1311eeee1313eeee1313eeee1313eeee1313eeee1313eeee1313eeee3313eeee
000000001111eeee1131eeee1131eeee3131eeee3131eeee3131eeee3131eeee3131eeee3131eeee3133eeee3133eeee3333eeee3333eeee3333eeee3333eeee
000000001111eeee1111eeee1111eeee1111eeee1111eeee1113eeee1113eeee1313eeee1313eeee1313eeee1313eeee1313eeee1313eeee1333eeee1333eeee
00000000eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
00000000eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
00000000eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
00000000eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
3333eeee3333eeee3333eeeeb333eeeeb333eeeeb3b3eeeeb3b3eeeeb3b3eeeeb3b3eeeeb3b3eeeeb3b3eeeebbb3eeeebbb3eeeebbbbeeeebbbbeeeebbbbeeee
3333eeee3333eeee3333eeee3333eeee3333eeee3333eeee3333eeee3b33eeee3b33eeee3b3beeee3b3beeee3b3beeee3b3beeee3b3beeee3b3beeeebb3beeee
3333eeee3333eeee33b3eeee33b3eeeeb3b3eeeeb3b3eeeeb3b3eeeeb3b3eeeeb3b3eeeeb3b3eeeeb3bbeeeeb3bbeeeebbbbeeeebbbbeeeebbbbeeeebbbbeeee
1333eeee3333eeee3333eeee3333eeee3333eeee3333eeee333beeee333beeee3b3beeee3b3beeee3b3beeee3b3beeee3b3beeee3b3beeee3bbbeeee3bbbeeee
eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
bbbbeeeebbbbeeeebbbbeeee7bbbeeee7bbbeeee7b7beeee7b7beeee7b7beeee7b7beeee7b7beeee7b7beeee777beeee777beeee7777eeee7777eeee7777eeee
bbbbeeeebbbbeeeebbbbeeeebbbbeeeebbbbeeeebbbbeeeebbbbeeeeb7bbeeeeb7bbeeeeb7b7eeeeb7b7eeeeb7b7eeeeb7b7eeeeb7b7eeeeb777eeeeb777eeee
bbbbeeeebbbbeeeebb7beeeebb7beeee7b7beeee7b7beeee7b7beeee7b7beeee7b7beeee7b7beeee7b77eeee7b77eeee7777eeee7777eeee7777eeee7777eeee
3bbbeeeebbbbeeeebbbbeeeebbbbeeeebbbbeeeebbbbeeeebbb7eeeebbb7eeeeb7b7eeeeb7b7eeeeb7b7eeeeb7b7eeeeb7b7eeeeb7b7eeeeb7b7eeee77b7eeee
eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000012345670000000000000000077777777700775000775077777777500000000000000000000000000000000000000000000000007000000000000000
0000000089abcdef0000000000000000076666666600765000765076666666500000000000000000000000000000000000000000000000077700000000000000
00000000000000000000000000000000000000000000765000765075555555500000000000000000000000000000000000000000000000777770000000000000
0000000000028ef70000000000000000077500000000765007765000000000000000000000000000000000000000000000000000000007777777000000000000
00000000000000000000000000000000076500000000765076665000000000000000000000000000000000000000000000000000000077777777700000000000
000000000015dc670000000000000000076500000000767765665077777777500000000000000000000000000000000000000000000777777777770000000000
00000000000000000000000000000000076500000000766650765076666666500000000000000000000000000000000000000000007777777777777000000000
00000000000249a70000000000000000076500000000765500765075555555500000000000000000000000000000000000000000077777777777777700000000
eeeeeee6eeeeeeee0000000000000000076500000000765000765000000000000000000000000000000000000000000000000000777777777777777770000000
eeeee6eee6eeeeee0000000000000000076500000000765000765000000000000000000000000000000000000000000000000007777777777777777777000000
eee6eeeeeee6eeee0000000000000000076500000000765000765000000000000000000000000000000000000000000000000077777777770777777777700000
ee6ee6e7e6ee6eee0000000000000000076777775000765000765077777777500000000000000000000000000000000000000777777777700077777777770000
eeee6e676e6eeeee0000000000000000076666665000765000765076666666500000000000000000000000000000000000007777777777007007777777777000
e6e6e67776e6e6ee0000000000000000075555555000765000765075555555500000000000000000000000000000000000077777777770077700777777777700
eeee6777776eeeee0000000000000000000000000000000000000000000000000000000000000000000000000000000000777777777700777770077777777770
6ee777777777ee6e0000000000000000000000000000000000000000000000000000000000000000000000000000000007777777777007777777007777777777
eeee6777776eeeee0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777700000000000
e6e6e67776e6e6ee0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777700000000000
eeee6e676e6eeeee0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777700000000000
ee6ee6e7e6ee6eee0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777700000000000
eee6eeeeeee6eeee0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777700000000000
eeeee6eee6eeeeee0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777700000000000
eeeeeee6eeeeeeee0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777700000000000
eeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777700000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777700000000000
00533000000000000000000000033000000000000000000000000000000000000000000000000000000000000000000000000000000077777777700000000000
05366b30000ee2000002220000333300000000000000000000000000000000000000000000000000000000000000000000000000000007777777700000000000
3bbbb3300ee77e00022ee2000336b300000000000000000000000000000000000000000000000000000000000000000000000000000007777777000000000000
3bbb330002eee0000022200003bb3000000000000000000000000000000000000000000000000000000000000000000000000000000000777770000000000000
00335000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000777700000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000070000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000006d000167d00000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000d7600761550000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000016017100005d0000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000550750000570000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000175000570000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000077777777777777777777777777700000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000001111111111111117d111571111100000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000010567d00170007d000570000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000005767d1660570007d000570000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000577100d70570007d000570000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000057d006760570007d000570000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000571001600570007d000570051000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000570000000570007d000570067000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000570000000570007d00017557d000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000057000000006000d5000057760000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000500000000000000000000000000000000000000000000000000000000000000000000000000000
057d0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0017d000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00057100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00006d00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000d700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00005700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00077777777777777777777777777777777777777776777777777777777777777777777777777777777777777777777777777777777777777777777777000000
00015711111111111115711111111571115711111110111111111111111111111111111111115711111157111111111111111711111111111111157111000000
00005716761000056776700005677670005700000150000000150016650000010567d0005677670000567716600010567d0007677610005676d1d67610000000
00005766516100577d116100577d1161005700000570000000570d77dd60005767d1660577d1161001761d667505767d1660076116600d761177751565000000
000057700056007710005600771000560057000005700d776057676000dd00577100d7077100056001700570100577100d700500057017d00177100057000000
000057500057017d000057017d000057005700000570011100577d0000570057d0067617d000057000d0177000057d0067600567767017100d760000d7000000
000057000057007100006700710000670057000005700000005760000067005710016007100006700677765000057100160067d1567007100051000177000000
00005700006700d100057700d1000577001710000670000000576000067600570000000d1000577017500d7760057000000175000d700d60000000577d000000
000057000d7d000511d775000511d7750006610167700000005716d67771005700000000511d7750066d7765d505700000017515677000650000067760000000
000006000660000056765000005676500000d77765700000005700d7760000570000000005676500006761000505700000001677656000055000017d00000000
000000000000000000000000000000000000001005700000005700000000000500000000000000006777d0000600500000000000000000000000000000000000
0000000000000000000000000000000000d6600005700000005700000000000000000000000000177655d6516700000000000000000000000000000000000000
000000000000000000000000000000000776d1000570000000570000000000000000000000000066100000567d00000000000000000000000000000000000000
00000000000000000000000000000000171000000660000000570000000000000000000000000160000000000000000000000000000000000000000000000000
000000000000000000000000000000000d6100056600000000170000000000000000000000000500000000000000000000000000000000000000000000000000
00000000000000000000000000000000001d66665000000000010000000000000000000000000000000000000000000000000000000000000000000000000000
__label__
00070007700777770777000777777777777777777777777757777777777ffffff777777777777777777777777777777777777777777777777777777777777777
0777070707777077077707077777777777777777777777775777777777ffffffff77777777777777777777777777777777777777777777777777777777777777
00f7000700077ff7000700077ff77ff77ff77ff77ff77ff75ff77ff77ffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff7
07770777770770770707070777777777777777777777777757777777fffff77fffff777777777777777777777777777777777777777777777777777777777777
0777077700777777000700077777777777777777777777775777777fffff7ff7fffff77777777777777777777777777777777777777777777777777777777777
777777777777777777777777777777777777777777777777577777fffff7ffff7fffff7777777777777777777777777777777777777777777777777777777777
7755555777777777777777777775555557777777777777775777775775555fff7777777755555577777777777777777555555777777777777777755555577777
755777757777777777777777755777775577777777777777577777575577ffff7777777557777557777777777777775577777557777777777777557777755777
557777775777777777777777557777777757777777777777577777555777ffff7777755777777775777777777777757777777755777777777775577777775577
577777777577777777777777577777777775777777777777577777557777ffff7777757777777777577777777777557777777775777777777755777777777557
5777777775777777777777f5777777777777577777777777577777577777ffff7777577777777777757777777777577777777775777777777757777777777757
777777777577777777777ff5f77777777777577777777777577777577777ffff7777577777777777757777777777557777777775777777777557777777777775
77777777755777777777ff55ff77777777775777777777775777775777777ff77775577777777777757777777777757777777777777777777577777777777775
7777777777577777777fff5ffff7777777775577777777775777775777777f777775777777777777775777777777755557777777777777777577777777777775
777777777757777777ffff5555555555555555777777777757777757777777777775777777777777775777777777777775555777777777777555555555555555
77777777775777777fffff57fffff777777777777777777757777757777777777775777777777777775777777777777777777557777777777577777777777777
7777777777577777fffff75f7fffff77777777777777777757777757777777777775777777777777755777777777777777777755777777777577777777777777
777777777757777fffff7ff5f7fffff7777757777777777757777757777777777777577777777777757777777775777777777775577777777577777777777775
777777777757777777777ff5f7777777777757777777777757777757777777777777577777777777757777777775577777777777577777777557777777777755
777777777757777777777ff557777777777577777777777757777757777777777777557777777777557777777777577777777777577777777757777777777757
777777777757777777777fff57777777775577777777777757777757777777777777755777777775577777777777557777777775577777777775777777777557
777777777757777777777ffff5577777755777777777777757777757777777777777775577777755777777777777755777777755777777777775577777775577
777777777757777777777ffff7555555557777777777777757777757777777777777777555555557777777777777777555555557777777777777755555557777
7777777f7777777777777ffff7777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777
777777fff7777777777777ff77777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777
77777fffff777777777777f777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777
7ff7fffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff7
ff7fffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77
f7fffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77f
7fffffffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff
fffffffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ffdddf77ff77ff77ff77ff77ff77ff77ff77ff7
ffffffffffffffff7777777777777777777777777777777777777777777777777777777777777777777777777dd777dd77777777777777777777777777777777
fffffffffffffffff7777777777777777777777777777777777777777777777777777ddd77777777777722222d22222d22222222777777777777777777777777
fffffff7ffffffffff77777777777777777777777777777777777777777777777777d777d777777222227777d7777777d7777777227777777777777777777777
fffffff77ffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ffd7ff77d2222277ff77ff7d2222227dff77ff77f227ff77ff77ff77ff77ff7
ffffff7fffffffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff7dff222d77ff2222222222df77ff72d222ff77ff772277ff77ff77ff77ff77
fffff7fff77ffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77d22222222227ff77ff77ffd7ff77df77f2222227ff722f77ff77ff77ff77f
ffff7fffffffffffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff222227ffd7ff77ff77ff77ff7ddf77dd77ff77ff7722222f22ff77ff77ff77ff
fff7fffffff77ffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77f2222f77ddd7ff77ff77ff77ff77ffdddf77ff77ff77ff77ff222227ff77ff77ff7
ff7fffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff772222ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77f2222277ff77ff77
f77ffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff722f772f77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff772277ff722277ff77f
77ffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff22ff77f277ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff722f77ff77ff722f77fd
7fffffffffff7ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77f227ff77ff72ff77ff77ff77ff77f222222222222222222222222222222222222222222222d
ff7fffffffffff77ff77ff77ff77ff77ff77ff77ff77ff77ff772277ff77ff7722222222222222222277ff77ff77ff77ff77ff772227ff77ff77ff77ff77ff2d
777fffffffff777777777777777777777777777777777777777277777722222272777777777777777777777ddd77777777777222777777777777777777777727
777fffffffff77777777777777777777777777777777777772272222227777777277777777777777777777d777d7777772222777777777777777777777777277
777fffffffff7777777777777777777777777777777777222222777777777777772222227777777777777d77777d222227777777777777777777777777772777
777fffffffff7777777777777777777777777777777222722777777777777777777777772222222222222d22222d777777777777777777777777777777727777
777fffffffff7777777777777777777777777777772777777222277777777777777777777777777777777d77777d777777777777777777777777777722277777
7777ffffffff77777777777777777777777777772277777777777222777777777777777777777777777777d72222222222222222222222222222222222222222
7777fffffff77777777777777777777777777772777777777777777722227777722222222222222222222222dd77777777777777777777722227777777777777
77777fffff7777777777777777777777777777277777777777777772222222222777d77777777777777777777777777777777222222222277777777777777777
f77ffffff77ff77ff77ff77ff77ff77ff77ff772277ddd222222222ff77ff77fd222d222277ff77ff77ff722222222222222277ff77ff77ff77ffdddf77ff77f
77ff77ff77ff77ff77ff77ff77fdddff77ff77f2222222df77ff77ff77ff77ffd7ffd7ff72222222222222ff77ff77ff77ff77ff77ff77ff77ffd7ffd7ff77f2
777777f7777777777777777777d777d77772222777d222d777777777777777777ddd77777777777777777777777777777777777777777777777d77777d222227
7777777777777777777777777d77777d2227777777d777d22222277777777777777777777777777777777777777777777777777777777777772d22222d777777
7777777777777777777777777d77222d77777777777dddd77777722222222227777777777777777777777777777777777777777772222222227d77777d777777
7777777777777777777777777d77772d2777777777dd777dd7777777777777722222222222222222222222222222222222222222222222222222222222222222
77777777777777777777777777d777d77222777777d77777d77777777777777777722222222222222222222222222222227777777777777777777ddd77777777
777777777777777777777777777ddd77777722222d7777777d777222222222222227777777777777777777777777777777777777777777777777777777777777
77777777777777777777777777777777777777772d2222222d22277777777777777777777777777777777777ddd7777777777777777777777772222222222222
77777777777777777777777777777722222222227d7777777d7772222222222222277777777777777777777d777d777777222222222222222227777777777777
777777777777777777777777722222777777777777d77777d77777777777777777722222222222222222222d222d222222777777777777777777777777777777
777777777777777777777777777227777777777777dd777dd77777777777777777777777777777777777777d777d777777777777777777777777777777777777
77777777777777777777777777777222227777777777ddd7777777777777777ddd7777777777777777ddddd7ddd7777777777777777777777777777777777777
77777777777777777777777777777777772222222222222222222222227777d777d77777777777777d77777d7777777777777777777777777777777222222222
77777777777777777777777777777777777777777777777777777777772222d222d2222222222222d2222222d222222222222222222222222222222777777777
ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77ffd7ffd7ff77ff77ff7dff77ff77fd77ff77ff77ff77ff77ff7ddd77ff77ff77ff77
f77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77fdddff77ff77ff77ff77ddd7ff77ff77ff77df77ff77ffd7ff77ff77ff77ff77ff7dff7dff77ff77ff77f
7777777777777777777777777777222222222222222d222d2222222222222222222222222222222d222222222d2222222222222222222d22222d222222222222
7777777777777777777777777777777772222222222d222d2222222222222222222222222222222222222222222222222222222222222d22222d222222222222
7777777777777777777777777777777777777777777d777d777777fff7777777777777777777777d777777777d7777777777777777777d77777d777777777777
77777777777777777777777777777777777777777777ddd777777fffff7777777777777777777777d7777777d77777ddd7777777777777d777d7777777777777
77ff77ff77ff77ff77ff77ff77ff77ff77ff77ffdddf77ff77ffffffffff77ff77ff77ff77ff77ff7dff77fd77ff7dff7dff77ff77ff77fdddff77ff77ff77ff
7ff77ff77ff77ff77ff77ff77ff77ff77ff77ffd7ffd7f22222222222222222222222222222222222222222222222d222d2222222222222222227ff77ff77ff7
ff77ff77ff77ff77ff77ff77ff77ff77ff77ff7d222d2277ffffffffffffff77ff77ff77ff77ff77ff77ff77ff77fd77fd77ff77ff77ff77ff77222222222222
777777777777777777777777777777777777722d777d77777fffffffffffff777777777777777777777777777ddd77ddd7777777777777777777777d77777d77
7777777777777777777777777777777777777277ddd77777fffffffffffffff7777777777777777777777777d777d7777777777777777777777777d7777777d7
77777777777777777777777777777777777772222222277fffffffffff222222222222222222222222222222d222d222222222222227777777777d777777777d
7777777777777777777777777777777777777777777772ddd2222222222222fff77777777777777777777777d777d77777777777777222222777d77777777777
f77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff775fdfffdf222ffffffff22222222222222222ff77ffdddfdddf77ff77ff77ff77ff77ff222222ff77ff77f
77ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77f5dffff2dfffff7fffffffffff77ff77ff77f22222d222d222222222222222222222222222d22222222222
77777777777777777777777777777777777777777775dff22fdff77f77ffffffffff7777222222222222d222d222777777777777777777777777d77777777772
ff77ff77ff77ff77ff77ff77ff77ff77ff77ff77fff5df2fffdfffffff7ffff222222222ff77ff77ff77df77df7722222222ff77ff77ff77ff77df77ff77ff77
f77ff77ff77ff77ff77ff77f577ff55ff77ff77ffff5fdfffdf555fff222222ffffff555f77ff77ff77ffd55577ff77ff77f2222227ff77ff77ffd7ff77ff77d
7777777777777777777777775775577557777777fff522ddd555f5552ff77ffffff55ff55577777777dd5557555777777777777777222222777777d7777777d7
777777777777777777777777575777775577777777757772552222f5ffff777777577777755777777d755d777755777777777777777777772222222d77777d7d
777777777777777777777777555777777557777777757777577f2dd55fff777775577722225222222d552d2227755777777777777777777777777772222dd7d7
777777777777777777777777557777777757777777757775777fd2ff5222222775222277775577777d577d777222522277777777777777777777777777722d77
777777777777777777777777557777777755777777757777777dff255dff77725522222277777777775dd777777757772222277777777777777777777777d227
777777777777777777777777577777777775777777757777777d55555dff7227577777772222222ddd577777777757777777722227777777777777777777d772
7777777777777777777777775777777777757777777577755555fff25df2277757777777777777d722555555555552222222777772222777777777777777d777
777777777777777777777777557777777755777777757775777fdfff522f777755777777777772d222522222222277777777222222222222222222222222d222
777777777777777777777777557777777757777777757775777ffddd5f2f777775777772222527d777577777777752227777777777777777222777777777d777
777777777777777777777777557777777557777777757775777ffff552f22777757222277757777ddd5577777775577722277777777777777772277777777d77
777777777777777777777777575777777577777777757775777fff555fff722222577777755777777775777777557777777222777777777777777227777777d7
7777777777777777777777775775577557777777777577775577f55f52ff777722555775557777ddd7775577755777777777772222777777777777722777777d
77777777777777777777777757775555777777777775777775555fff552777772777555522777d777d7777555777777777777777772222777777777772277777
77777777777777777777777757777777777777777777777777777fffff727dd2777777777722d22777d722222777777777777777777777227777777777722777
77777777777777777777777757777777777777777777777777777ffff777d772d77777777772d22222d222777222777777777777777777772777777777772777
f77ff77ff77ff77ff77ff77f577ff77ff77ff77ff77ff77ff77ff7fff77df272fd7ff722222fd77ff7dff7222222222ff77ff77ff77ff77ff27ff77ff77f2772
777777777777777777777777577777777777777777777777777777f7777d77222d77727777777d777d7777777777777222222222777777777722222222222227
77777777777777777777777777777777777777777777777777777777777d77772d722777777777ddd77777777777777777222777222222222227277777772777
777777777777777777777777777777777777777777777777777777777777d7772722277777777777777777777777777777777222777777777777727777772777
7777777777777777777777777777777777777777777777777777777777777ddd7227722277777ddd777777777777777777777777227777777777772777727777
7777777777777777777777777777777777777777777777777777777777777777722777772277d777d77777777777777777777777772777777777727777727777
777777777777777777777777777777777777777777777777777777777777777777227777772d27777d7777777777777777777777777277777777277777727777
777777777777777777777777777777777777777777777777777777777777777777272277777d22222d2222222222222777777777777277777772777777727777
777777777777777777777777777777777777777777777777777777777777777777277722222d77dd7d2222227777777227777777777727777727777777727777
7777777777777777777777777777777777777777777777777777777777777777772777772d77d77dd77777772222227772277777777772777277772222227777
777777777777777777777777777777777777777777777777777777777777777777727777d2227dddd77777777777772222222777777722222222227777777777
777777777777777777777777777777777777777777777777777777777777777777772277d2772277d77777777777777777772222222227727777777777777777
777777777777777777777777777777777777777777777777777777777777777777777727d2777722d27777777777777777777727777272277777777777777777
7777777777777777777777777777777777777777777777777777777777777777777777727d27777d77222277ddd7777777777727722227777777777777777777
77777777777777777777777777777777777777777777777777777777777777777777777722d227dd777777dd227dd77777777722272777777777777777777777
77777777777777777777777777777777777777777777777777777777777777777777777777222277777777d77722d27ddd222227727777777777777777777777
7777777777777777777777777777777777777777777777777777777777777777777777777777772222222d7777777dd222dd2777727777777777777777777777
7777777777777777777777777777777777777777777777777777777777777777777777777777777722777d2222222d22222d2222277777777777777777777777
7777777777777777777777777777777777777777777777777777777777777777777777777777777777222d777777dd777227d777777777777777777777777777
77777777777777777777777777777777777777777777777777777777777777777777777777777777777772222222d2222777d777777777777777777777777777
77777777777777777777777777777777777777777777777777777777777777777777777777777777777777dd777dd7777777d777777777777777777777777777
7777777777777777777777777777777777777777777777777777777777777777777777777777777777777777ddd77d77777d7777777777777777777777777777
777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777dd777dd7777777777777777777777777777
77777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777ddd777777777777777777777777777777
77777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777
77777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777
77777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777
77777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777

__sfx__
011000011803000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000000c62500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000000c1350c1100c1350c1300c1100c1350c1100c1300c1100c1350c1300c1100c1350c1100c1350c1300c1100c1350c1300c1100c1300c1100c1350c1300c1350c1100c1350c1300c1100c1350c1350c110
011000000c1350c1100c1350c1300c1100c1350c1100c1300c1100c1350c1300c1100c1350c1100c1350c1300c110111351113011110111301111011135111301113511110111351113011110111351113511110
011000001613516110161351613016110161351611016130161101613516130161101613516110161351613016110151351513015110151301511015135151301513515110181351813018110181351813518110
0110000011135111101113511130111101113511110111301111011135111301111011135111101113511130111100e1350e1300e1100e1300e1100e1350e1300e1350e110111351113011110111351113511110
011000000c1350c1100c1350c1300c1100c1350c1100c1300c1100c1350c1300c1100c1350c1100c1350c1300c1100f1350f1300f1100f1300f1100f1350f1300f1350f1100f1350f1300f1100f1350f1350f110
011000001313513110131351313013110131351311013130131101313513130131101313513110131351313013110111351113011110111301111011135111301113511110111351113011110111351113511110
011000001813518110181351813018110181351811018130181101813518130181101813518110181351813018110161351613016110161301611016135161301613516110161351613016110161351613516110
011000000f1350f1100f1350f1300f1100f1350f1100f1300f1100f1350f1300f1100f1350f1100f1350f1300f110111351113011110111301111011135111301113516110161351613015110151351513515110
011000001613516110161351613016110161351611016130161101613516130161101613516110161351613016110161351613016110161301611016135161301613518110181351813018110181351813518110
011000001a1351a1101a1351a1301a1101a1351a1101a1301a1101a1351a1301a1101a1351a1101a1351a1301a11018135181301811018130181101813518130181351d1101d1351d1301d1101d1351d1351d110
011000001d1351d1101c1351c1301c1101c1351c1101c1301c1101c1351c1301c1101c1351c1101c1351d1301d1101a1351a1301a1101a1301a1101a1351a1301a13518110181351813018110181351813518110
011000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000000c1751110518155131550c12518155131550c1251a17518155131551a15518155131251a155181551d17513125181551d15513125181551c17518125131551c12518155131551c125131551a15518155
011000200c1751110518155131550c12518155131550c1251a17518155131551a15518155131251a155181551d17513125181551d15513125181551f17518125131551f12518155131551f125131551a15518155
011000000a1751110518155111550a12518155111550a1251a17518155111551a155181550a1251a1551815509175111251815511155091251815511175091251a15518125111551a15518125091551c15518155
011000000c5751110518565135650c52518565135650c5251a57518565135651a56518565135251a565185651d57513525185651d56513525185651c57518525135651c52518565135651c525135651a56518565
011000000c5751150518555135550c52518555135550c5251a57518555135551a55518555135251a555185551d57513525185551d55513525185551f57518525135551f52518555135551f525135551a55518555
011000000f5751110516555115550f52516555115550f52516575115550f55516555115550f525165550f55515575165251155516555155251155516575155251155516525155551155516525155551155515555
01100000085750010518555165550f52518555165550f5251b575165550f5551a555165550f5251855516555115750a5251855516555115251855516575115251b55516525115551d55516525115551855516555
011000000c00300000000000c0030c605006030c00318003000000000000000000000000000000000000000000000000000000000000000000000000000000000c06300000000000c0630c665006230c05318053
011000000c07300000000400c0530c645000630c063000000007300000000400c0630c645000630c063000000c07300000000400c0630c645000630c063000000006300000000400c0630c645000630c06300000
011000000c07300000000400c0530c6450c0400c063000000007300000000400c0630c645000630c063000000c07300000000400c0630c6450c0400c0630000000063000000a0400c0630c645050400c06300000
011000001881018810188201882018830188301883018830188301883018830188301883018830188301883018830188301883018830188301883018830188301883018830188301883018830188301883018830
0110000000000000000000000000000000000000000000001d8101d8101d8201d8201d8301d8301d8301d8301c8111c8111c8201c8201c8301c8301c8301c8301c8301c8301c8301c8301c8301c8301c8301c830
0110000000000000000000000000000000000000000000001d8101d8101d8201d8201d8301d8301d8301d8301f8111f8111f8201f8201f8301f8301f8301f8301f8301f8301f8301f8301f8301f8301f8301f830
0110000000000000000000000000000000000000000000001d8101d8101d8201d8201d8301d8301d8301d8301f8111f8111f8201f8201f8301f8301f8301f8301f8301f8301f8301f8301f016240261f03624036
011000001b8101b8101b8201b8201b8301b8301b8301b8301b8301b8301b8301b8301b8301b8301b8301b8301d8301d8301d8301d8301d8301d8301d8301d8301d8301d8301d8301d8301d8301d8301d8301d830
011000001d016220261d036220361d036220361d036220361d036220361d036220361d036220361d036220361d016210261d036210361d036210361d03621036160161d026160361d036150361d036150361d036
01100000180161f026180361f036180361f036180361f036180361f036180361f036180361f036180361f036180361f036180361f036180261f026180161f0161f016240261f036240361f036240361f03624036
01100000140161b026140361b036140361b036140361b036140361b036140361b036140361b036140361b036160161a026160361a036160361a036160361a0361601611026160361103616036110361603611036
011000001301618026130261802613026180261302618026130261802613026180261302618026130261802613016180161301618016130161801613016180161301618016130161801613016180161301618016
011000000c6250c6050c9350c6050c915000000c915000000c1330c6050c9350c6050c925000000c915000000c1330c6050c9350c6050c925000000c915000000c1330c6050c9350c6050c925000000c91500000
011000000c710117101372016720187301d7301f73022730247300c730117301373016730187301d7301f73022730247300c730117301373016730187301d7301f73022730247300c73011730137301673018730
0110000000000000000c710117101371016710187101d7101f71022710247100c710117101371016710187101d7101f71022710247100c710117101371016710187101d7101f71022710247100c7101171013710
011000001f71021710247200c720117301373015730187301d7301f73021730247300c730117301373015730187301d7301f73021730247300c730117301373015730187301d7301f73021730247300c73011730
0110000016710187101f71021710247100c710117101371015710187101d7101f71021710247100c710117101371015710187101d7101f71021710247100c710117101371015710187101d7101f7102171024710
011000000c15000000000000c1301815000000181301615016000161301610016000161500000011150131300c15000000000000c130181500000018130161501600016130161001600016150000001115013130
011000000c1350c1100c1350c1300c1100c1350c1100c1300a1100a1350a1300a1100a1350a1100a1350a1300c1100c1350c1300c1100c1300c1100c1350c1300c1350a1100a1350a1300a1100a1350a1350a110
011000000c1350c1100c1350c1300c1100c1350c1100c1300c1101113511130111101113511110111351113016110161351613016110161301611016135161301613515110151351513015110151351513515110
011000001885018830188201882018810000001f8501f8301f8201f8201f8101f8001d8501d8301d8201d8201d8101d8101d8101d810000001d8501d8301d8201d8201d810000001885018830188201882018810
001000001f8501f8301f8201f8201f810000002485024830248202482024810000002285022830228202282022810000002285022830228202282022810000001685016830168201682016810000001d8501d830
001000001685016830168201682016810000001b8501b8301b8201b8201b810000001885018830188201882018810188101881018810000001d8501d8301d8201d8201d810000001885018830188201882018810
001000001f8501f8301f8201f8201f810000002285022830228202282022810000002185021830218202182021810000001f8501f8301f8201f8201f810000001185011830118201182011810000001d8501d830
001000001885018830188201882018810000001485014830148201482014810000001685016830168201682016810000001a8501a8301a8201a8201a810000001a8501a8301a8201a8201a810000001185011830
001000001f8501f8301f8201f8201f810000001b8501b8301b8201b8201b810000001d8501d8301d8201d8201d8101d8101d81000000000001b8501b8301b8201b8201b810000001685016830168201682016810
011000000c120000000c1200f1200f1000c120000000c120000000c1200012000000041200000000120000000e120000000e1100f1200f1000e120000000a120000000f1200e1100a1100e1300f1100a13000000
011000001813018830188201882018810000001f8501f8301f8201f8201f8101f8001d8501d8301d8201d8201d8101d8101d8101d810000001d8501d8301d8201d8201d810000001885018830188201882018810
0110000003120000000a11011120111000f120000000312000000031100f1200000011120000000f1200000005120000000c1101312013100111200000005120000000c110131201510011120000000a12000000
0010000008120000000f1100e120000000a1200000008120000000f12000000000000e120000000a1200000005120000000f1100e120000000a120000000e120000000511007120000000a120000000e12000000
011000000c1350c1100c1350c1300c1100c1350c1100c1300c1100c1250c1200c1100c1200c1100c1250c1300c1100c1150c1100c1000c1100c1000c1100c1100c1000c1100c1100c1000c1000c1000c1000c100
01100000131351311013135131301311013135131101313013110131251312013110131201311013125131301311013115131100c100131100c10013110131100c10013110131100c1000c1000c1000c1000c100
01100000181351811018135181301811018135181101813018110181251812018110181201811018125181301811018115181100c100181100c10018110181100c10018110181100c1000c1000c1000c1000c100
__music__
00 08090846
00 080b0a46
00 0c0d0e46
00 0f10111b
00 0c0d0e1d
00 0f10111d
00 120d0e1d
00 0f10111d
00 141e1f1c
00 151e201c
00 161e201c
00 141e1f1c
00 171e1f1c
00 181e211c
00 1922231c
00 181e241c
00 1922231c
00 1a42251c
00 28292627
00 2a2b2627
00 28292c27
00 2a2b2c27
00 2d492c1d
00 082e2c1d
00 0e0d2c1d
00 11102c1d
00 3630351c
00 3132371c
00 2f30351c
00 3132371c
00 3334381c
00 141e1f1c
00 151e201c
00 161e201c
00 141e1f1c
00 171e1f1c
00 181e211c
00 1922231c
00 1a42251c
00 08090844
00 080a0b44
00 0c0d0e44
00 0f101144
00 393a3b44

